/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.browserNotifications;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.dispatch.actionControllers.TemplateActionController;
import com.aptana.portal.ui.dispatch.browserNotifications.AbstractBrowserNotification;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.templates.IProjectTemplateListener;
import java.util.HashMap;
import org.eclipse.core.runtime.Plugin;

public class TemplatesNotification
extends AbstractBrowserNotification {
    private IProjectTemplateListener listener;

    public synchronized void start() {
        this.isListening = true;
        ProjectsPlugin.getDefault().getTemplatesManager().addListener(this.getListener());
        IdeLog.logInfo((Plugin)ProjectsPlugin.getDefault(), (String)"Template Portal notifier started", (String)"com.aptana.portal.ui/debug/startpage");
    }

    public synchronized void stop() {
        this.isListening = false;
        ProjectsPlugin.getDefault().getTemplatesManager().removeListener(this.getListener());
        this.listener = null;
        IdeLog.logInfo((Plugin)ProjectsPlugin.getDefault(), (String)"Template Portal notifier stopped", (String)"com.aptana.portal.ui/debug/startpage");
    }

    protected void notifyAdd(IProjectTemplate template) {
        IdeLog.logInfo((Plugin)ProjectsPlugin.getDefault(), (String)"Template added. Notifying portal...", (String)"com.aptana.portal.ui/debug/startpage");
        this.notifyTargets("templates", "added", this.createTemplateInfo(template), true);
    }

    protected void notifyRemoved(IProjectTemplate template) {
        IdeLog.logInfo((Plugin)ProjectsPlugin.getDefault(), (String)"Template removed. Notifying portal...", (String)"com.aptana.portal.ui/debug/startpage");
        this.notifyTargets("templates", "deleted", this.createTemplateInfo(template), true);
    }

    protected String createTemplateInfo(IProjectTemplate template) {
        HashMap<String, String> templateInfo = new HashMap<String, String>();
        templateInfo.put(TemplateActionController.TEMPLATE_INFO.ID.toString(), template.getId());
        templateInfo.put(TemplateActionController.TEMPLATE_INFO.NAME.toString(), template.getDisplayName());
        templateInfo.put(TemplateActionController.TEMPLATE_INFO.DESCRIPTION.toString(), template.getDescription());
        templateInfo.put(TemplateActionController.TEMPLATE_INFO.TEMPLATE_TYPE.toString(), template.getType().name());
        return JSON.toString(templateInfo);
    }

    protected synchronized IProjectTemplateListener getListener() {
        if (this.listener == null) {
            this.listener = new IProjectTemplateListener(){

                public void templateAdded(IProjectTemplate template) {
                    if (TemplatesNotification.this.isListening) {
                        TemplatesNotification.this.notifyAdd(template);
                    }
                }

                public void templateRemoved(IProjectTemplate template) {
                    if (TemplatesNotification.this.isListening) {
                        TemplatesNotification.this.notifyRemoved(template);
                    }
                }
            };
        }
        return this.listener;
    }
}

